<?php
class Registry {
  /**
   * @var array Magazyn na wszystkie nasze obiekty
   */
  static private $_store = array();
  
  /**
   * Dodaje obiekt do rejestru
   * 
   * Jeśli nie zostanie podana nazwa, zostanie użyta nazwa klasy
   *
   * @param mixed $object Obiekt, który ma zostać zapisany
   * @param string $name Nazwa, wg której należy odwoływać się do obiektu
   * @return mixed W przypadku nadpisania obiektu, zostanie zwrócony poprzedni obiekt.
   * @throws Exception
   */
  static public function add($object, $name = null)
  {
    // Jeśli nie podano nazwy, zostanie użyta nazwa klasy — symulacja singletona
    $name = (!is_null($name)) ?: get_class($object);
    $name = strtolower($name);
    
    $return = null;
    if (isset(self::$_store[$name])) {
      // Zapisanie starego obiektu do zwrotu
      $return = self::$_store[$name];
    }
    
    self::$_store[$name]= $object;
    return $return;
  }
  
  /**
   * Pobiera obiekt z rejestru
   *
   * @param string $name Nazwa obiektu, {@see self::set()}
   * @return mixed
   * @throws Exception
   */
  static public function get($name)
  {
    if (!self::contains($name)) {
      throw new Exception("Nie ma takiego obiektu w rejestrze");
    }
    
    return self::$_store[$name];
  }
  
  /**
   * Sprawdza czy dany obiekt znajduje się w rejestrze
   *
   * @param string $name Nazwa obiektu, {@see self::set()}
   * @return bool
   */
  static public function contains($name)
  {
    if (!isset(self::$_store[$name])) {
      return false;
    }
    
    return true;
  }
  
  /**
   * Usuwa obiekt z rejestru
   *
   * @param string $name Nazwa obiektu, {@see self::set()}
   * @returns void
   */
  static public function remove($name)
  {
    if (self::contains($name)) {
      unset(self::$_store[$name]);
    }
  }
}
?>